/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures;

import com.mojang.serialization.Codec;
import com.telepathicgrunt.repurposedstructures.mixin.structures.PoolElementStructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePieceAccessor;
import com.telepathicgrunt.repurposedstructures.world.structures.AbstractBaseStructure;
import com.telepathicgrunt.repurposedstructures.world.structures.configs.RSMonumentConfig;
import com.telepathicgrunt.repurposedstructures.world.structures.pieces.MonumentPieces;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_1973;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_3443;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3790;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import net.minecraft.class_6880;
import net.minecraft.class_7059;

public class MonumentStructure<C extends RSMonumentConfig>
extends AbstractBaseStructure<C> {
    public MonumentStructure(Codec<C> codec) {
        super(codec, MonumentStructure::isMonumentFeatureChunk, MonumentStructure::generateMonumentPieces);
    }

    protected static <CC extends RSMonumentConfig> boolean isMonumentFeatureChunk(class_6834.class_6835<CC> context) {
        class_1923 chunkPos = context.comp_309();
        RSMonumentConfig config = (RSMonumentConfig)context.comp_310();
        if (!(context.comp_307() instanceof class_1973)) {
            for (int curChunkX = chunkPos.field_9181 - config.biomeRadius; curChunkX <= chunkPos.field_9181 + config.biomeRadius; ++curChunkX) {
                for (int curChunkZ = chunkPos.field_9180 - config.biomeRadius; curChunkZ <= chunkPos.field_9180 + config.biomeRadius; ++curChunkZ) {
                    int yValue = config.fixedYSpawn.orElse(context.comp_306().method_20402(curChunkX << 4, curChunkZ << 4, class_2902.class_2903.field_13194, context.comp_311()));
                    class_6880 biome = context.comp_307().method_38109(curChunkX << 2, yValue >> 2, curChunkZ << 2, context.comp_306().method_38276());
                    if (context.comp_312().test(biome)) continue;
                    return false;
                }
            }
        }
        for (class_5321<class_7059> structureSetToAvoid : config.structureSetToAvoid) {
            if (!context.comp_306().method_41053(structureSetToAvoid, context.comp_308(), chunkPos.field_9181, chunkPos.field_9180, config.structureAvoidRadius)) continue;
            return false;
        }
        return true;
    }

    public static <CC extends RSMonumentConfig> Optional<class_6622<CC>> generateMonumentPieces(class_6834.class_6835<CC> context) {
        int finalheight;
        RSMonumentConfig config = (RSMonumentConfig)context.comp_310();
        class_1923 chunkPos = context.comp_309();
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        class_2338 centerPoint = chunkPos.method_33943(0);
        if (config.fixedYSpawn.isPresent()) {
            finalheight = config.fixedYSpawn.get();
        } else {
            int centerHight;
            float centerWeight = config.centerTerrainHeightWeight.orElse(Float.valueOf(1.0f)).floatValue();
            int highestLandPos = centerHight = context.comp_306().method_18028(centerPoint.method_10263(), centerPoint.method_10260(), class_2902.class_2903.field_13194, context.comp_311());
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(centerPoint.method_10263() + 29, centerPoint.method_10260() + 29, class_2902.class_2903.field_13194, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(centerPoint.method_10263() - 29, centerPoint.method_10260() + 29, class_2902.class_2903.field_13194, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(centerPoint.method_10263() + 29, centerPoint.method_10260() - 29, class_2902.class_2903.field_13194, context.comp_311()));
            highestLandPos = Math.min(highestLandPos, context.comp_306().method_18028(centerPoint.method_10263() - 29, centerPoint.method_10260() - 29, class_2902.class_2903.field_13194, context.comp_311()));
            finalheight = (int)((float)(highestLandPos - centerHight) / centerWeight) + centerHight;
        }
        if (finalheight <= context.comp_306().method_33730()) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            List<class_3443> list = MonumentPieces.createMonumentBuilding(context.comp_314(), context.comp_313(), (Random)random, centerPoint.method_10263(), finalheight, centerPoint.method_10260(), config);
            class_2470 rotation = class_2470.method_16548((Random)random);
            class_2338 mainOffset = new class_2338(-29, 0, -29).method_10070(rotation);
            for (class_3443 structurePiece : list) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolPiece = (class_3790)structurePiece;
                ((PoolElementStructurePieceAccessor)poolPiece).setRotation(poolPiece.method_16888().method_10501(rotation));
                class_2338 piecePos = poolPiece.method_16648();
                class_2338 offsetPos = piecePos.method_10059((class_2382)centerPoint);
                class_2338 rotatedOffset = offsetPos.method_10070(rotation);
                poolPiece.method_14922(rotatedOffset.method_10263() - offsetPos.method_10263(), 0, rotatedOffset.method_10260() - offsetPos.method_10260());
                poolPiece.method_14922(mainOffset.method_10263(), 0, mainOffset.method_10260());
                class_3784 patt7064$temp = poolPiece.method_16644();
                if (!(patt7064$temp instanceof class_3781)) continue;
                class_3781 singlePoolElement = (class_3781)patt7064$temp;
                class_3499 structuretemplate = ((SinglePoolElementAccessor)singlePoolElement).callGetTemplate(context.comp_313());
                ((StructurePieceAccessor)poolPiece).setBoundingBox(structuretemplate.method_16187(new class_3492().method_15123(rotation), poolPiece.method_16648()));
            }
            list.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
        });
    }
}

